{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 22.03.99 - 15:51:59 $                                        =}
{========================================================================}
unit CDConfig;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  ComCtrls,
  MMObj,
  MMUtils,
  MMSpin,
  MMEdit,
  MMCDRead,
  MMCDATyp;

type
  TConfigDlg = class(TForm)
    PageControl1: TPageControl;
    General: TTabSheet;
    btnCancel: TButton;
    btnOK: TButton;
    lblBlockcount: TLabel;
    edBlockCount: TMMNumberEdit;
    spinBlockcount: TMMSpinButton;
    radioCopyMode: TRadioGroup;
    comboDeviceType: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Panel1: TPanel;
    edDeviceName: TEdit;
    ckbIgnoreSpeed: TCheckBox;
    ckbReadCDText: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure spinBlockcountChange(Sender: TObject);
    procedure edBlockCountExit(Sender: TObject);
  private
  public
  end;

var
  ConfigDlg: TConfigDlg;

implementation

uses CDMain;

{$R *.DFM}

{-- TConfigDlg ----------------------------------------------------------------}
procedure TConfigDlg.FormShow(Sender: TObject);
var
   i: integer;

begin
   for i := 0 to high(CDDeviceTypes) do
   begin
      comboDeviceType.Items.Add(CDDeviceTypes[i]);
   end;

   with CDMainForm,CDReader do
   begin
      comboDeviceType.ItemIndex := Ord(DeviceType);
      radioCopyMode.ItemIndex   := Ord(CopyMode);
      spinBlockCount.Value      := BlockCount;
      edBlockCount.Value        := BlockCount;
      edDeviceName.Text         := '<'+DriveLetter+':>  '+DeviceName;
      ckbIgnoreSpeed.Checked    := IgnoreSpeed;
      ckbReadCDText.Checked     := UseCDText;
   end;
end;

{-- TConfigDlg ----------------------------------------------------------------}
procedure TConfigDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if (ModalResult = mrOK) then
   with CDMainForm,CDReader do
   begin
      DeviceType   := TCDDeviceType(comboDeviceType.ItemIndex);
      CopyMode     := TMMCDCopyMode(radioCopyMode.ItemIndex);
      BlockCount   := spinBlockCount.Value;
      IgnoreSpeed  := ckbIgnoreSpeed.Checked;
      UseCDText    := ckbReadCDText.Checked;
   end;
end;

{-- TConfigDlg ----------------------------------------------------------------}
procedure TConfigDlg.spinBlockCountChange(Sender: TObject);
begin
   edBlockCount.Value := spinBlockCount.Value;
end;

{-- TConfigDlg ----------------------------------------------------------------}
procedure TConfigDlg.edBlockCountExit(Sender: TObject);
begin
   spinBlockCount.Value := edBlockCount.Value;
end;

end.

